"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnstructuredGraph = getUnstructuredGraph;
var _langgraph = require("@langchain/langgraph");
var _unstructured = require("./unstructured");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  logSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  currentPattern: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  grokPatterns: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  jsonSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  unParsedSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  errors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  additionalProcessors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  ecsVersion: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  isFirst: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  }
};
function modelInput({
  state
}) {
  return {
    finalized: false,
    isFirst: true,
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput({
  state
}) {
  return {
    finalized: true,
    additionalProcessors: state.additionalProcessors,
    lastExecutedChain: 'modelOutput'
  };
}
function validationRouter({
  state
}) {
  if (Object.keys(state.unParsedSamples).length === 0) {
    return 'modelOutput';
  }
  return 'handleUnparsed';
}
async function getUnstructuredGraph({
  model,
  client
}) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', state => modelInput({
    state
  })).addNode('modelOutput', state => modelOutput({
    state
  })).addNode('handleUnstructured', state => (0, _unstructured.handleUnstructured)({
    state,
    model,
    client
  })).addNode('handleUnstructuredValidate', state => (0, _validate.handleUnstructuredValidate)({
    state,
    model,
    client
  })).addEdge(_langgraph.START, 'modelInput').addEdge('modelInput', 'handleUnstructured').addEdge('handleUnstructured', 'handleUnstructuredValidate').addConditionalEdges('handleUnstructuredValidate', state => validationRouter({
    state
  }), {
    handleUnparsed: 'handleUnstructured',
    modelOutput: 'modelOutput'
  }).addEdge('modelOutput', _langgraph.END);
  const compiledUnstructuredGraph = workflow.compile();
  return compiledUnstructuredGraph;
}