"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleUnstructuredValidate = handleUnstructuredValidate;
var _util = require("../../util");
var _processors = require("../../util/processors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleUnstructuredValidate({
  state,
  client
}) {
  const currentPattern = state.currentPattern;
  const grokPatterns = state.grokPatterns;
  const grokProcessor = (0, _processors.createGrokProcessor)([...grokPatterns, currentPattern]);
  const pipeline = {
    processors: grokProcessor,
    on_failure: [(0, _processors.createPassthroughFailureProcessor)()]
  };
  const packageName = state.packageName;
  const dataStreamName = state.dataStreamName;
  const validSamples = [];
  const unParsedSamples = [];
  const errors = [];
  for (const sample of state.logSamples) {
    const result = await (0, _util.testPipeline)([sample], pipeline, client);
    if (result.errors.length > 0) {
      unParsedSamples.push(sample);
      errors.push(result.errors[0]);
    } else {
      validSamples.push(result.pipelineResults[0]);
    }
  }
  if (validSamples.length > 0) {
    grokPatterns.push(currentPattern);
  }
  if (unParsedSamples.length > 0) {
    return {
      unParsedSamples,
      errors,
      lastExecutedChain: 'unstructuredValidate'
    };
  }
  const jsonSamples = validSamples.map(log => log[packageName]).map(log => log[dataStreamName]).map(log => JSON.stringify(log));
  const additionalProcessors = state.additionalProcessors;
  additionalProcessors.push(grokProcessor[0]);
  return {
    jsonSamples,
    additionalProcessors,
    unParsedSamples: [],
    lastExecutedChain: 'unstructuredValidate'
  };
}