"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileLimiter = void 0;
var _domain = require("../../../../common/types/domain");
var _constants = require("../../../../common/constants");
var _utils = require("../../utils");
var _base_limiter = require("../base_limiter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FileLimiter extends _base_limiter.BaseLimiter {
  constructor(fileService) {
    super({
      limit: _constants.MAX_FILES_PER_CASE,
      attachmentType: _domain.AttachmentType.externalReference,
      field: 'externalReferenceAttachmentTypeId',
      attachmentNoun: 'files'
    });
    this.fileService = fileService;
  }
  async countOfItemsWithinCase(caseId) {
    const files = await this.fileService.find({
      perPage: 1,
      meta: {
        caseIds: [caseId]
      }
    });
    return files.total;
  }
  countOfItemsInRequest(requests) {
    let fileRequests = 0;
    for (const request of requests) {
      if ((0, _utils.isFileAttachmentRequest)(request)) {
        fileRequests += request.externalReferenceMetadata.files.length;
      }
    }
    return fileRequests;
  }
}
exports.FileLimiter = FileLimiter;