"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesConnectorRetryService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _cases_connector_error = require("./cases_connector_error");
var _retry_service = require("../../common/retry_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CasesConnectorRetryService extends _retry_service.RetryService {
  constructor(logger, backOffFactory, maxAttempts = 10) {
    super(logger, backOffFactory, 'CasesConnector', maxAttempts);
    /**
     * 409 - Conflict
     * 429 - Too Many Requests
     * 503 - ES Unavailable
     *
     * Full list of errors: src/core/packages/saved-objects/server/src/saved_objects_error_helpers.ts
     */
    (0, _defineProperty2.default)(this, "RETRY_ERROR_STATUS_CODES", [409, 429, 503]);
  }
  isRetryableError(error) {
    if (error instanceof _cases_connector_error.CasesConnectorError && this.RETRY_ERROR_STATUS_CODES.includes(error.statusCode)) {
      return true;
    }
    this.logger.debug(`[CasesConnector][isRetryableError] Error is not retryable`, {
      tags: ['case-connector:retry-error']
    });
    return false;
  }
}
exports.CasesConnectorRetryService = CasesConnectorRetryService;