"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesNumberCustomField = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesNumberCustomField = () => ({
  isFilterable: false,
  isSortable: false,
  savedObjectMappingType: 'long',
  validateFilteringValues: values => {
    values.forEach(value => {
      if (value !== null && !Number.isSafeInteger(value)) {
        throw _boom.default.badRequest('Unsupported filtering value for custom field of type number.');
      }
    });
  }
});
exports.getCasesNumberCustomField = getCasesNumberCustomField;