"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkPostObservableRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkPostObservableRoute = exports.bulkPostObservableRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.INTERNAL_BULK_CREATE_CASE_OBSERVABLES_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    })
  },
  routerOptions: {
    access: 'internal',
    summary: 'Bulk add case observables',
    description: `Each case can have a maximum of ${_constants.MAX_OBSERVABLES_PER_CASE} observables.`
    // You must have `all` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on the owner of the case you're creating.
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const caseId = request.params.case_id;
      const {
        observables
      } = request.body;
      const theCase = await casesClient.cases.bulkAddObservables({
        caseId,
        observables
      });
      return response.ok({
        body: theCase
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to post observable in route case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});