"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setPostCloudSolutionDataRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/core/server");
var _saved_objects = require("../saved_objects");
var _cloud_data = require("../cloud_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBodySchemaV1 = _configSchema.schema.object({
  onboardingData: _configSchema.schema.object({
    solutionType: _configSchema.schema.oneOf([_configSchema.schema.literal('security'), _configSchema.schema.literal('observability'), _configSchema.schema.literal('search'), _configSchema.schema.literal('elasticsearch')]),
    token: _configSchema.schema.string()
  })
});
const setPostCloudSolutionDataRoute = ({
  router
}) => {
  router.versioned.post({
    path: `/internal/cloud/solution`,
    access: 'internal',
    summary: 'Save cloud data for solutions',
    security: {
      authz: {
        requiredPrivileges: [_server.ReservedPrivilegesSet.superuser]
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: createBodySchemaV1
      }
    }
  }, async (context, request, response) => {
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.getClient({
      includedHiddenTypes: [_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE]
    });
    try {
      await (0, _cloud_data.persistTokenCloudData)(savedObjectsClient, {
        returnError: true,
        solutionType: request.body.onboardingData.solutionType,
        onboardingToken: request.body.onboardingData.token
      });
    } catch (error) {
      return response.customError(error);
    }
    return response.ok();
  });
};
exports.setPostCloudSolutionDataRoute = setPostCloudSolutionDataRoute;