"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LazyCspFindingsVulnerabilityFlyoutHeader = exports.LazyCspFindingsVulnerabilityFlyoutFooter = exports.LazyCspFindingsVulnerabilityFlyoutBody = exports.LazyCspFindingsVulnerabilityFlyout = exports.LazyCspFindingsMisconfigurationFlyoutHeader = exports.LazyCspFindingsMisconfigurationFlyoutFooter = exports.LazyCspFindingsMisconfigurationFlyoutBody = exports.LazyCspFindingsMisconfigurationFlyout = exports.CspPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _csp_loading_state = require("./components/csp_loading_state");
var _constants = require("../common/constants");
var _setup_context = require("./application/setup_context");
var _experimental_features = require("../common/experimental_features");
var _experimental_features_service = require("./common/experimental_features_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyCspPolicyTemplateForm = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/policy_template_form'))));
const LazyCspCustomAssets = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/custom_assets_extension'))));

// Misconfiguration Flyout Components
const LazyCspFindingsMisconfigurationFlyout = exports.LazyCspFindingsMisconfigurationFlyout = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/configurations/findings_flyout/findings_flyout'))));
const LazyCspFindingsMisconfigurationFlyoutHeader = exports.LazyCspFindingsMisconfigurationFlyoutHeader = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/configurations/findings_flyout/findings_right/header'))));
const LazyCspFindingsMisconfigurationFlyoutBody = exports.LazyCspFindingsMisconfigurationFlyoutBody = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/configurations/findings_flyout/findings_right/content'))));
const LazyCspFindingsMisconfigurationFlyoutFooter = exports.LazyCspFindingsMisconfigurationFlyoutFooter = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/configurations/findings_flyout/findings_right/footer'))));

// Vulnerability Flyout Components
const LazyCspFindingsVulnerabilityFlyout = exports.LazyCspFindingsVulnerabilityFlyout = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_finding_flyout'))));
const LazyCspFindingsVulnerabilityFlyoutHeader = exports.LazyCspFindingsVulnerabilityFlyoutHeader = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_finding_right/header'))));
const LazyCspFindingsVulnerabilityFlyoutBody = exports.LazyCspFindingsVulnerabilityFlyoutBody = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_finding_right/content'))));
const LazyCspFindingsVulnerabilityFlyoutFooter = exports.LazyCspFindingsVulnerabilityFlyoutFooter = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_finding_right/footer'))));
const CspRouterLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application/csp_router'))));
const CspRouter = props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 23
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(CspRouterLazy, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 5
  }
})));
class CspPlugin {
  constructor(initializerContext) {
    var _parseExperimentalCon;
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = (_parseExperimentalCon = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || [])) === null || _parseExperimentalCon === void 0 ? void 0 : _parseExperimentalCon.features;
  }
  setup(_core, plugins) {
    this.isCloudEnabled = plugins.cloud.isCloudEnabled;
    if (plugins.usageCollection) _ui_metrics.uiMetricService.setup(plugins.usageCollection);

    // Return methods that should be available to other plugins
    return {};
  }
  start(core, plugins) {
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    plugins.fleet.registerExtension({
      package: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME,
      view: 'package-policy-replace-define-step',
      Component: LazyCspPolicyTemplateForm
    });
    plugins.fleet.registerExtension({
      package: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME,
      view: 'package-detail-assets',
      Component: LazyCspCustomAssets
    });
    const storage = new _public2.Storage(localStorage);

    // Keep as constant to prevent remounts https://github.com/elastic/kibana/issues/146773
    const App = props => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...core,
        ...plugins,
        storage
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: core,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        width: '100%',
        height: '100%'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_setup_context.SetupContext.Provider, {
      value: {
        isCloudEnabled: this.isCloudEnabled
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(CspRouter, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }))))));
    return {
      getCloudSecurityPostureRouter: () => App,
      getCloudSecurityPostureMisconfigurationFlyout: () => {
        return {
          Component: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 155,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 155,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsMisconfigurationFlyout, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 156,
              columnNumber: 15
            }
          }), props.children)),
          Header: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 162,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 162,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsMisconfigurationFlyoutHeader, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 163,
              columnNumber: 15
            }
          }))),
          Body: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 167,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 167,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsMisconfigurationFlyoutBody, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 168,
              columnNumber: 15
            }
          }))),
          Footer: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 172,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 172,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsMisconfigurationFlyoutFooter, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 173,
              columnNumber: 15
            }
          })))
        };
      },
      getCloudSecurityPostureVulnerabilityFlyout: () => {
        return {
          Component: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 181,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 181,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsVulnerabilityFlyout, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 182,
              columnNumber: 15
            }
          }), props.children)),
          Header: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 188,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 188,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsVulnerabilityFlyoutHeader, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 189,
              columnNumber: 15
            }
          }))),
          Body: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 193,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 193,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsVulnerabilityFlyoutBody, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 194,
              columnNumber: 15
            }
          }))),
          Footer: props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
            fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 198,
                columnNumber: 33
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 198,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(LazyCspFindingsVulnerabilityFlyoutFooter, (0, _extends2.default)({}, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 199,
              columnNumber: 15
            }
          })))
        };
      }
    };
  }
  stop() {}
}
exports.CspPlugin = CspPlugin;