"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCspPackagePolicyInstalled = void 0;
var _helpers = require("../../common/utils/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isCspPackagePolicyInstalled = async (packagePolicyClient, soClient, logger) => {
  try {
    const {
      total
    } = await packagePolicyClient.list(soClient, {
      kuery: _helpers.CSP_FLEET_PACKAGE_KUERY,
      page: 1
    });
    return total > 0;
  } catch (e) {
    logger.error(e);
    return false;
  }
};
exports.isCspPackagePolicyInstalled = isCspPackagePolicyInstalled;