"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_OTHER_ASSIGNMENT_INDEX = exports.DEFAULT_OTHER_ASSIGNMENT = exports.DEFAULT_NEUTRAL_PALETTE_INDEX = exports.DEFAULT_COLOR_MAPPING_CONFIG = void 0;
exports.getColorsFromMapping = getColorsFromMapping;
exports.getPaletteColors = getPaletteColors;
exports.getPaletteColorsFromPaletteId = getPaletteColorsFromPaletteId;
var _color_handling = require("../color/color_handling");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_NEUTRAL_PALETTE_INDEX = exports.DEFAULT_NEUTRAL_PALETTE_INDEX = 1;
const DEFAULT_OTHER_ASSIGNMENT_INDEX = exports.DEFAULT_OTHER_ASSIGNMENT_INDEX = 0;
const DEFAULT_OTHER_ASSIGNMENT = exports.DEFAULT_OTHER_ASSIGNMENT = {
  rules: [{
    type: 'other'
  }],
  color: {
    type: 'loop'
  },
  touched: false
};
/**
 * The default color mapping used in Kibana, starts with the EUI color palette
 */
const DEFAULT_COLOR_MAPPING_CONFIG = exports.DEFAULT_COLOR_MAPPING_CONFIG = {
  assignments: [],
  specialAssignments: [DEFAULT_OTHER_ASSIGNMENT],
  paletteId: 'default',
  colorMode: {
    type: 'categorical'
  }
};
function getPaletteColors(palettes, colorMappings) {
  const colorMappingModel = colorMappings !== null && colorMappings !== void 0 ? colorMappings : {
    ...DEFAULT_COLOR_MAPPING_CONFIG
  };
  const palette = palettes.get(colorMappingModel.paletteId);
  return getPaletteColorsFromPaletteId(palettes, palette.id);
}
function getPaletteColorsFromPaletteId(palettes, paletteId) {
  const palette = palettes.get(paletteId);
  return Array.from({
    length: palette.colorCount
  }, (d, i) => palette.getColor(i));
}
function getColorsFromMapping(palettes, isDarkMode, colorMappings) {
  const {
    colorMode,
    paletteId,
    assignments,
    specialAssignments
  } = colorMappings !== null && colorMappings !== void 0 ? colorMappings : {
    ...DEFAULT_COLOR_MAPPING_CONFIG
  };
  if (colorMode.type === 'gradient') {
    const colorScale = (0, _color_handling.getGradientColorScale)(colorMode, palettes, isDarkMode);
    return Array.from({
      length: 6
    }, (d, i) => colorScale(i / 6));
  } else {
    const palette = palettes.get(paletteId);
    const otherColor = (0, _utils.getOtherAssignmentColor)(specialAssignments, assignments);
    const otherColors = otherColor.isLoop ? Array.from({
      length: palette.colorCount
    }, (d, i) => palette.getColor(i)) : [(0, _color_handling.getColor)(otherColor.color, palettes)];
    return [...assignments.map(a => {
      return a.color.type === 'gradient' ? '' : (0, _color_handling.getColor)(a.color, palettes);
    }), ...otherColors].filter(color => color !== '');
  }
}