"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpecialString = exports.SPECIAL_TOKENS_STRING_CONVERSION = void 0;
var _i18n = require("@kbn/i18n");
var _fieldFormatsCommon = require("@kbn/field-formats-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// TODO: move in some data/table related package
const SPECIAL_TOKENS_STRING_CONVERSION = exports.SPECIAL_TOKENS_STRING_CONVERSION = new Map([['__other__', _i18n.i18n.translate('coloring.colorMapping.terms.otherBucketLabel', {
  defaultMessage: 'Other'
})], ['', _fieldFormatsCommon.EMPTY_LABEL]]);

/**
 * Returns special string for sake of color mapping/syncing
 */
const getSpecialString = value => {
  var _SPECIAL_TOKENS_STRIN;
  return (_SPECIAL_TOKENS_STRIN = SPECIAL_TOKENS_STRING_CONVERSION.get(value)) !== null && _SPECIAL_TOKENS_STRIN !== void 0 ? _SPECIAL_TOKENS_STRIN : value;
};
exports.getSpecialString = getSpecialString;