"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectColorMode = selectColorMode;
exports.selectColorPickerVisibility = selectColorPickerVisibility;
exports.selectComputedAssignments = selectComputedAssignments;
exports.selectPalette = selectPalette;
exports.selectSpecialAssignments = selectSpecialAssignments;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function selectPalette(palettes) {
  return state => palettes.get(state.colorMapping.paletteId);
}
function selectColorMode(state) {
  return state.colorMapping.colorMode;
}
function selectSpecialAssignments(state) {
  return state.colorMapping.specialAssignments;
}
function selectColorPickerVisibility(state) {
  return state.ui.colorPicker;
}
function selectComputedAssignments(state) {
  return state.colorMapping.assignments;
}