"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyncJobs = exports.FetchSyncJobsApiLogic = void 0;
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSyncJobs = async ({
  connectorId,
  http,
  from = 0,
  size = 10,
  type
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/sync_jobs`;
  const query = {
    from,
    size,
    type
  };
  return await (http === null || http === void 0 ? void 0 : http.get(route, {
    query
  }));
};
exports.fetchSyncJobs = fetchSyncJobs;
const FetchSyncJobsApiLogic = exports.FetchSyncJobsApiLogic = (0, _create_api_logic.createApiLogic)(['search_connectors_content', 'fetch_sync_api_logic'], fetchSyncJobs);