"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.createConnectorBreadcrumbs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _kea = require("kea");
var _app_context = require("../../../app_context");
var _add_connector_api_logic = require("../../../api/connector/add_connector_api_logic");
var _new_connector_logic = require("../../new_index/method_connector/new_connector_logic");
var _generate_step_state = require("../utils/generate_step_state");
var _connector_logos_comp = _interopRequireDefault(require("./assets/connector_logos_comp.png"));
var _configuration_step = require("./configuration_step");
var _deployment_step = require("./deployment_step");
var _finish_up_step = require("./finish_up_step");
var _error_to_text = require("../utils/error_to_text");
var _page_template = require("../../shared/page_template");
var _use_breadcrumbs = require("../../../utils/use_breadcrumbs");
var _use_kibana = require("../../../utils/use_kibana");
var _connectors = require("../connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/create_connector/create_connector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StartStep = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./start_step'))));
const createConnectorBreadcrumbs = exports.createConnectorBreadcrumbs = [..._connectors.connectorsBreadcrumbs, {
  text: _i18n.i18n.translate('xpack.contentConnectors.content.connectors.createBreadcrumb', {
    defaultMessage: 'Create Connector'
  }),
  href: '/select_connector'
}];
const CreateConnector = () => {
  var _overlays$openConfirm, _selectedConnector$ic;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const query = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const filter = query.get('filter');
  const {
    services: {
      overlays,
      http,
      application
    }
  } = (0, _public.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    isAgentlessEnabled
  } = (0, _app_context.useAppContext)();
  const {
    services: {
      chrome,
      appParams
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    error
  } = (0, _kea.useValues)(_add_connector_api_logic.AddConnectorApiLogic);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [selfManagePreference, setSelfManagePreference] = (0, _react.useState)('native');
  (0, _use_breadcrumbs.useBreadcrumbs)(createConnectorBreadcrumbs, appParams, chrome);
  const {
    selectedConnector,
    currentStep,
    isFormDirty,
    connectorId
  } = (0, _kea.useValues)((0, _new_connector_logic.NewConnectorLogic)({
    http,
    navigateToUrl: application === null || application === void 0 ? void 0 : application.navigateToUrl
  }));
  const {
    setCurrentStep
  } = (0, _kea.useActions)((0, _new_connector_logic.NewConnectorLogic)({
    http,
    navigateToUrl: application === null || application === void 0 ? void 0 : application.navigateToUrl
  }));
  const stepStates = (0, _generate_step_state.generateStepState)(currentStep);
  (0, _react.useEffect)(() => {
    if (selectedConnector && !selectedConnector.isNative && selfManagePreference === 'native' || !isAgentlessEnabled || filter === 'connector_clients') {
      setSelfManagePreference('selfManaged');
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedConnector]);
  const getSteps = selfManaged => {
    return [{
      children: null,
      status: stepStates.start,
      title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.startLabel', {
        defaultMessage: 'Start'
      })
    }, ...(selfManaged ? [{
      children: null,
      status: stepStates.deployment,
      title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.deploymentStep.deploymentLabel', {
        defaultMessage: 'Deployment'
      })
    }] : []), {
      children: null,
      status: stepStates.configure,
      title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.configurationStep.configurationLabel', {
        defaultMessage: 'Configuration'
      })
    }, {
      children: null,
      status: stepStates.finish,
      title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.finishUpLabel', {
        defaultMessage: 'Finish up'
      })
    }];
  };
  const stepContent = {
    configure: /*#__PURE__*/_react.default.createElement(_configuration_step.ConfigurationStep, {
      title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.configurationStep.configurationLabel', {
        defaultMessage: 'Configuration'
      }),
      setCurrentStep: setCurrentStep,
      connectorId: connectorId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    }),
    deployment: /*#__PURE__*/_react.default.createElement(_deployment_step.DeploymentStep, {
      setCurrentStep: setCurrentStep,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 17
      }
    }),
    finish: /*#__PURE__*/_react.default.createElement(_finish_up_step.FinishUpStep, {
      title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.finishUpLabel', {
        defaultMessage: 'Finish up'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 7
      }
    }),
    start: /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 27
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(StartStep, {
      title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.startStep.startLabel', {
        defaultMessage: 'Start'
      }),
      selfManagePreference: selfManagePreference,
      setCurrentStep: setCurrentStep,
      onSelfManagePreferenceChange: preference => {
        setSelfManagePreference(preference);
      },
      error: (0, _error_to_text.errorToText)(error),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }))
  };
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    cancelButtonText: _i18n.i18n.translate('xpack.contentConnectors.createConnector.unsavedPrompt.cancel', {
      defaultMessage: 'Continue setup'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.contentConnectors.createConnector.unsavedPrompt.confirm', {
      defaultMessage: 'Leave the page'
    }),
    hasUnsavedChanges: isFormDirty,
    history: history,
    http: http,
    messageText: _i18n.i18n.translate('xpack.contentConnectors.createConnector.unsavedPrompt.body', {
      defaultMessage: 'Your connector is created but missing some details. You can complete the setup later in the connector configuration page, but this guided flow offers more help.'
    }),
    navigateToUrl: application.navigateToUrl,
    openConfirm: (_overlays$openConfirm = overlays === null || overlays === void 0 ? void 0 : overlays.openConfirm) !== null && _overlays$openConfirm !== void 0 ? _overlays$openConfirm : () => Promise.resolve(false),
    titleText: _i18n.i18n.translate('xpack.contentConnectors.createConnector.unsavedPrompt.title', {
      defaultMessage: 'Your connector is not fully configured'
    })
  });
  return /*#__PURE__*/_react.default.createElement(_page_template.SearchConnectorsPageTemplateWrapper, {
    pageHeader: {
      description: _i18n.i18n.translate('xpack.contentConnectors.createConnector.description', {
        defaultMessage: 'Extract, transform, index and sync data from a third-party data source.'
      }),
      pageTitle: _i18n.i18n.translate('xpack.contentConnectors.createConnector..title', {
        defaultMessage: 'Create a connector'
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    color: "subdued",
    paddingSize: "l",
    css: (0, _react2.css)`
              ${currentStep === 'start' ? `background-image: url(${_connector_logos_comp.default});` : ''}
              background-size: contain;
              background-repeat: no-repeat;
              background-position: bottom center;
              min-height: 550px;
              border: 1px solid ${euiTheme.colors.lightShade};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    titleSize: "xxs",
    steps: getSteps(selfManagePreference === 'selfManaged'),
    css: () => (0, _react2.css)`
                .euiStep__content {
                  padding-block-end: ${euiTheme.size.xs};
                }
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 13
    }
  }), (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.docsUrl) && (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.docsUrl) !== '' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    "data-test-subj": "enterpriseSearchCreateConnectorConnectorDocsLink",
    href: selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.docsUrl,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 21
    }
  }, 'Elastic ', selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.name, _i18n.i18n.translate('xpack.contentConnectors.createConnector.connectorDocsLinkLabel', {
    defaultMessage: ' connector reference'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 17
    }
  })), currentStep !== 'start' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.contentConnectors.createConnector.euiFormRow.connectorLabel', {
      defaultMessage: 'Connector'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    readOnly: true,
    valueOfSelected: "item1",
    options: [{
      inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "l",
        type: (_selectedConnector$ic = selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.iconPath) !== null && _selectedConnector$ic !== void 0 ? _selectedConnector$ic : '',
        css: (0, _react2.css)`
                                margin-right: ${euiTheme.size.m};
                              `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 292,
          columnNumber: 29
        }
      }), selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.name),
      value: 'item1'
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 17
    }
  }, selfManagePreference === 'selfManaged' ? _i18n.i18n.translate('xpack.contentConnectors.createConnector.badgeType.selfManaged', {
    defaultMessage: 'Self-managed'
  }) : _i18n.i18n.translate('xpack.contentConnectors.createConnector.badgeType.ElasticManaged', {
    defaultMessage: 'Elastic managed'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  }, stepContent[currentStep])));
};
// eslint-disable-next-line import/no-default-export
exports.default = CreateConnector;