"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _connector_helpers = require("../../../utils/connector_helpers");
var _sync_jobs_view_logic = require("./sync_jobs_view_logic");
var _access_control_index_selector = require("../access_control_index_selector/access_control_index_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/sync_jobs/sync_jobs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SyncJobs = ({
  connector
}) => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const shouldShowAccessSyncs = (0, _connector_helpers.hasDocumentLevelSecurityFeature)(connector);
  const errorOnAccessSync = Boolean(connector.last_access_control_sync_error);
  const errorOnContentSync = Boolean(connector.last_sync_error);
  const [selectedIndexType, setSelectedIndexType] = (0, _react.useState)('content-index');
  const {
    connectorId,
    syncJobsPagination: pagination,
    syncJobs,
    cancelSyncJobLoading,
    syncJobToCancel,
    selectedSyncJobCategory,
    syncTriggeredLocally
  } = (0, _kea.useValues)((0, _sync_jobs_view_logic.SyncJobsViewLogic)({
    http
  }));
  const {
    setConnectorId,
    fetchSyncJobs,
    cancelSyncJob,
    setCancelSyncJob,
    setSelectedSyncJobCategory
  } = (0, _kea.useActions)((0, _sync_jobs_view_logic.SyncJobsViewLogic)({
    http
  }));
  (0, _react.useEffect)(() => {
    setConnectorId(connector.id);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connector]);
  (0, _react.useEffect)(() => {
    if (connectorId) {
      var _pagination$pageSize;
      fetchSyncJobs({
        connectorId,
        from: pagination.pageIndex * (pagination.pageSize || 0),
        size: (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : 10,
        type: selectedSyncJobCategory,
        http
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [connectorId, selectedSyncJobCategory]);
  (0, _react.useEffect)(() => {
    if (selectedIndexType === 'content-index') {
      setSelectedSyncJobCategory('content');
    } else {
      setSelectedSyncJobCategory('access_control');
    }
  }, [selectedIndexType, setSelectedSyncJobCategory]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowAccessSyncs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
                min-width: ${euiTheme.base * 18}px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_access_control_index_selector.AccessControlIndexSelector, {
    fullWidth: true,
    onChange: setSelectedIndexType,
    valueOfSelected: selectedIndexType,
    indexSelectorOptions: [{
      description: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.contentIndexSync.description', {
        defaultMessage: 'Browse content sync history'
      }),
      error: errorOnContentSync,
      title: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.contentIndexSync.title', {
        defaultMessage: 'Content syncs'
      }),
      value: 'content-index'
    }, {
      description: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selector.accessControlSync.description', {
        defaultMessage: 'Browse access control sync history'
      }),
      error: errorOnAccessSync,
      title: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.documents.selectorSync.accessControl.title', {
        defaultMessage: 'Access control syncs'
      }),
      value: 'access-control-index'
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.accessControlIndexSelector.p.accessControlSyncsAreLabel', {
      defaultMessage: 'Access control syncs keep permissions information up to date for document level security (DLS)'
    })),
    position: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  })), selectedSyncJobCategory === 'content' ? /*#__PURE__*/_react.default.createElement(_searchConnectors.SyncJobsTable, {
    isLoading: syncTriggeredLocally,
    onPaginate: ({
      page: {
        index,
        size
      }
    }) => {
      if (connectorId) {
        fetchSyncJobs({
          connectorId,
          from: index * size,
          size,
          type: selectedSyncJobCategory
        });
      }
    },
    pagination: pagination,
    syncJobs: syncJobs,
    type: "content",
    cancelConfirmModalProps: {
      isLoading: cancelSyncJobLoading,
      onConfirmCb: syncJobId => {
        cancelSyncJob({
          syncJobId
        });
      },
      setSyncJobIdToCancel: setCancelSyncJob,
      syncJobIdToCancel: syncJobToCancel !== null && syncJobToCancel !== void 0 ? syncJobToCancel : undefined
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_searchConnectors.SyncJobsTable, {
    isLoading: syncTriggeredLocally,
    onPaginate: ({
      page: {
        index,
        size
      }
    }) => {
      if (connectorId) {
        fetchSyncJobs({
          connectorId,
          from: index * size,
          size,
          type: 'access_control'
        });
      }
    },
    cancelConfirmModalProps: {
      isLoading: cancelSyncJobLoading,
      onConfirmCb: syncJobId => {
        cancelSyncJob({
          syncJobId
        });
      },
      setSyncJobIdToCancel: setCancelSyncJob,
      syncJobIdToCancel: syncJobToCancel !== null && syncJobToCancel !== void 0 ? syncJobToCancel : undefined
    },
    pagination: pagination,
    syncJobs: syncJobs,
    type: "access_control",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }));
};
exports.SyncJobs = SyncJobs;