"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.update = void 0;
var _schemas = require("../../../common/schemas");
var _content_client = require("../../content_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const update = exports.update = {
  schemas: _schemas.rpcSchemas.update,
  fn: async (ctx, {
    contentTypeId,
    id,
    version,
    data,
    options
  }) => {
    const clientFactory = (0, _content_client.getContentClientFactory)({
      contentRegistry: ctx.contentRegistry
    });
    const client = clientFactory(contentTypeId).getForRequest({
      ...ctx,
      version
    });
    return client.update(id, data, options);
  }
};