"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NestedSecondaryMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _secondary_menu = require("../secondary_menu");
var _use_nested_menu = require("./use_nested_menu");
var _menu_panel = require("./menu_panel");
var _header = require("./header");
var _menu_item = require("./menu_item");
var _primary_menu_item = require("./primary_menu_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/core/packages/chrome/navigation/src/components/nested_secondary_menu/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NestedSecondaryMenu = ({
  children,
  initialPanel = 'main'
}) => {
  const [currentPanel, setCurrentPanel] = (0, _react.useState)(initialPanel);
  const [panelStack, setPanelStack] = (0, _react.useState)([]);
  const [returnFocusId, setReturnFocusId] = (0, _react.useState)();
  const goToPanel = (0, _react.useCallback)((panelId, focusId) => {
    setPanelStack(prev => [...prev, {
      id: currentPanel,
      returnFocusId: focusId || returnFocusId
    }]);
    setCurrentPanel(panelId);
    setReturnFocusId(undefined);
  }, [currentPanel, returnFocusId]);
  const goBack = (0, _react.useCallback)(() => {
    setPanelStack(prev => {
      const previousPanel = prev[prev.length - 1];
      if (!previousPanel) return prev;
      setCurrentPanel(previousPanel.id);
      setReturnFocusId(previousPanel.returnFocusId);
      return prev.slice(0, -1);
    });
  }, []);
  const contextValue = {
    canGoBack: panelStack.length > 0,
    currentPanel,
    goBack,
    goToPanel,
    panelStackDepth: panelStack.length,
    returnFocusId
  };
  return /*#__PURE__*/_react.default.createElement(_use_nested_menu.NestedMenuContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 10
    }
  }, children);
};
exports.NestedSecondaryMenu = NestedSecondaryMenu;
NestedSecondaryMenu.Panel = _menu_panel.Panel;
NestedSecondaryMenu.Header = _header.Header;
NestedSecondaryMenu.Item = _menu_item.Item;
NestedSecondaryMenu.PrimaryMenuItem = _primary_menu_item.PrimaryMenuItem;
NestedSecondaryMenu.Section = _secondary_menu.SecondaryMenu.Section;