"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StylesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _disable_animations = _interopRequireDefault(require("./disable_animations.css?raw"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// @ts-expect-error

/** @internal */
class StylesService {
  constructor() {
    (0, _defineProperty2.default)(this, "uiSettingsSubscription", void 0);
  }
  async setup() {}
  async start({
    uiSettings
  }) {
    const disableAnimationsStyleTag = document.createElement('style');
    disableAnimationsStyleTag.setAttribute('id', 'disableAnimationsCss');
    document.head.appendChild(disableAnimationsStyleTag);
    const setDisableAnimations = disableAnimations => {
      disableAnimationsStyleTag.textContent = disableAnimations ? _disable_animations.default : '';
    };
    this.uiSettingsSubscription = uiSettings.get$('accessibility:disableAnimations').subscribe(setDisableAnimations);
  }
  async stop() {
    if (this.uiSettingsSubscription) {
      this.uiSettingsSubscription.unsubscribe();
      this.uiSettingsSubscription = undefined;
    }
  }
}
exports.StylesService = StylesService;