"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSettingDefault = exports.getSettingDefault = exports.areAllSettingsDefault = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSettingDefault = name => {
  if (!_constants.FOLLOWER_INDEX_ADVANCED_SETTINGS[name]) {
    throw new Error(`Unknown setting ${name}`);
  }
  return _constants.FOLLOWER_INDEX_ADVANCED_SETTINGS[name];
};
exports.getSettingDefault = getSettingDefault;
const isSettingDefault = (name, value) => {
  return getSettingDefault(name) === value;
};
exports.isSettingDefault = isSettingDefault;
const areAllSettingsDefault = settings => {
  return Object.keys(_constants.FOLLOWER_INDEX_ADVANCED_SETTINGS).every(name => isSettingDefault(name, settings[name]));
};
exports.areAllSettingsDefault = areAllSettingsDefault;