"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEnhancedPlugin = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _kibana_services = require("./services/kibana_services");
var _embeddable_to_dashboard_drilldown = require("./services/drilldowns/embeddable_to_dashboard_drilldown");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class DashboardEnhancedPlugin {
  constructor(context) {
    this.context = context;
  }
  setup(core, plugins) {
    const start = (0, _public2.createStartServicesGetter)(core.getStartServices);
    const dashboardToDashboardDrilldown = new _embeddable_to_dashboard_drilldown.EmbeddableToDashboardDrilldown({
      start
    });
    plugins.uiActionsEnhanced.registerDrilldown(dashboardToDashboardDrilldown);
    return {};
  }
  start(core, plugins) {
    (0, _kibana_services.setKibanaServices)(core, plugins);
    (0, _kibana_services.untilPluginStartServicesReady)().then(() => {
      plugins.uiActionsEnhanced.addTriggerActionAsync(_public.CONTEXT_MENU_TRIGGER, 'OPEN_FLYOUT_ADD_DRILLDOWN', async () => {
        const {
          flyoutCreateDrilldownAction
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/drilldowns/actions/flyout_create_drilldown')));
        return flyoutCreateDrilldownAction;
      });
      plugins.uiActionsEnhanced.addTriggerActionAsync(_public.CONTEXT_MENU_TRIGGER, 'OPEN_FLYOUT_EDIT_DRILLDOWN', async () => {
        const {
          flyoutEditDrilldownAction
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/drilldowns/actions/flyout_edit_drilldown')));
        return flyoutEditDrilldownAction;
      });
    });
    return {};
  }
  stop() {}
}
exports.DashboardEnhancedPlugin = DashboardEnhancedPlugin;