"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformPanelsIn = transformPanelsIn;
var _uuid = require("uuid");
var _common = require("../../../../../common");
var _kibana_services = require("../../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformPanelsIn(widgets) {
  const panels = [];
  const sections = [];
  const panelReferences = [];
  widgets === null || widgets === void 0 ? void 0 : widgets.forEach(widget => {
    if ((0, _common.isDashboardSection)(widget)) {
      var _grid$i;
      const {
        panels: sectionPanels,
        grid,
        ...restOfSection
      } = widget;
      const idx = (_grid$i = grid.i) !== null && _grid$i !== void 0 ? _grid$i : (0, _uuid.v4)();
      sections.push({
        ...restOfSection,
        gridData: {
          ...grid,
          i: idx
        }
      });
      sectionPanels.forEach(panel => {
        const {
          storedPanel,
          references
        } = transformPanelIn(panel);
        panels.push({
          ...storedPanel,
          gridData: {
            ...storedPanel.gridData,
            sectionId: idx
          }
        });
        panelReferences.push(...references);
      });
    } else {
      // widget is a panel
      const {
        storedPanel,
        references
      } = transformPanelIn(widget);
      panels.push(storedPanel);
      panelReferences.push(...references);
    }
  });
  return {
    panelsJSON: JSON.stringify(panels),
    sections,
    references: panelReferences
  };
}
function transformPanelIn(panel) {
  var _references;
  const {
    uid,
    grid,
    config,
    ...restPanel
  } = panel;
  const idx = uid !== null && uid !== void 0 ? uid : (0, _uuid.v4)();
  const transforms = _kibana_services.embeddableService === null || _kibana_services.embeddableService === void 0 ? void 0 : _kibana_services.embeddableService.getTransforms(panel.type);
  let transformedPanelConfig = config;
  let references;
  try {
    if (transforms !== null && transforms !== void 0 && transforms.transformIn) {
      const transformed = transforms.transformIn(config);
      transformedPanelConfig = transformed.state;
      references = transformed.references;
    }
  } catch (transformInError) {
    // do not prevent save if transformIn throws
    _kibana_services.logger.warn(`Unable to transform "${panel.type}" embeddable state on save. Error: ${transformInError.message}`);
  }
  return {
    storedPanel: {
      ...restPanel,
      embeddableConfig: transformedPanelConfig,
      panelIndex: idx,
      gridData: {
        ...grid,
        i: idx
      }
    },
    references: (0, _common.prefixReferencesFromPanel)(idx, (_references = references) !== null && _references !== void 0 ? _references : [])
  };
}