"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityDetailsContextProvider = DatasetQualityDetailsContextProvider;
exports.useDatasetQualityDetailsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_breadcrumbs = require("../../utils/use_breadcrumbs");
var _url_state_storage_service = require("./url_state_storage_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/data_quality/public/routes/dataset_quality_details/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatasetQualityDetailsContext = /*#__PURE__*/(0, _react.createContext)({});
function DatasetQualityDetailsContextProvider({
  children,
  urlStateStorageContainer,
  toastsService,
  datasetQuality
}) {
  const [controller, setController] = (0, _react.useState)();
  const history = (0, _reactRouterDom.useHistory)();
  const [breadcrumbs, setBreadcrumbs] = (0, _react.useState)([]);
  (0, _use_breadcrumbs.useBreadcrumbs)(breadcrumbs);
  (0, _react.useEffect)(() => {
    async function getDatasetQualityDetailsController() {
      const initialState = (0, _url_state_storage_service.getDatasetQualityDetailsStateFromUrl)({
        urlStateStorageContainer,
        toastsService
      });

      // state initialization is under progress
      if (initialState === undefined) {
        return;
      }

      // state initialized but empty
      if (initialState === null) {
        history.push('/');
        return;
      }
      const datasetQualityDetailsController = await datasetQuality.createDatasetQualityDetailsController({
        initialState
      });
      datasetQualityDetailsController.service.start();
      setController(datasetQualityDetailsController);
      const datasetQualityStateSubscription = datasetQualityDetailsController.state$.subscribe(state => {
        var _state$integration;
        (0, _url_state_storage_service.updateUrlFromDatasetQualityDetailsState)({
          urlStateStorageContainer,
          datasetQualityDetailsState: state
        });
        const breadcrumbValue = (0, _use_breadcrumbs.getBreadcrumbValue)(state.dataStream, (_state$integration = state.integration) === null || _state$integration === void 0 ? void 0 : _state$integration.integration);
        setBreadcrumbs([{
          text: breadcrumbValue
        }]);
      });
      return () => {
        datasetQualityDetailsController.service.stop();
        datasetQualityStateSubscription.unsubscribe();
      };
    }
    getDatasetQualityDetailsController();
  }, [datasetQuality, history, toastsService, urlStateStorageContainer]);
  return /*#__PURE__*/_react.default.createElement(DatasetQualityDetailsContext.Provider, {
    value: {
      controller
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, children);
}
const useDatasetQualityDetailsContext = () => {
  const context = (0, _react.useContext)(DatasetQualityDetailsContext);
  if (context === undefined) {
    throw new Error('useDatasetQualityDetailContext must be used within a <DatasetQualityDetailsContextProvider />');
  }
  return context;
};
exports.useDatasetQualityDetailsContext = useDatasetQualityDetailsContext;