"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.boolean = boolean;
exports.date = date;
exports.dateNanos = dateNanos;
exports.flattened = flattened;
exports.integer = integer;
exports.keyword = keyword;
exports.long = long;
exports.short = short;
exports.text = text;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function text(def) {
  const defaults = {
    type: 'text',
    fields: {
      keyword: {
        type: 'keyword',
        ignore_above: 1024
      }
    }
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function keyword(def) {
  const defaults = {
    type: 'keyword',
    ignore_above: 1024
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function date(def) {
  const defaults = {
    type: 'date'
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function dateNanos(def) {
  const defaults = {
    type: 'date_nanos'
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function integer(def) {
  const defaults = {
    type: 'integer'
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function long(def) {
  const defaults = {
    type: 'long'
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function short(def) {
  const defaults = {
    type: 'short'
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function boolean(def) {
  const defaults = {
    type: 'boolean'
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}
function flattened(def) {
  const defaults = {
    type: 'flattened'
  };
  return (0, _lodash.defaultsDeep)(def, defaults);
}