"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataPrompt = void 0;
exports.DocumentationLink = DocumentationLink;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/data_view_management/public/components/add_data_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DocumentationLink({
  href
}) {
  return /*#__PURE__*/_react2.default.createElement("dl", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("dt", {
    className: "eui-displayInline",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.noDataViewsPrompt.learnMore",
    defaultMessage: "Want to learn more?",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 11
    }
  }))), "\u2003", /*#__PURE__*/_react2.default.createElement("dd", {
    className: "eui-displayInline",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank",
    external: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.noDataViewsPrompt.readDocumentation",
    defaultMessage: "Read the docs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }))));
}
// Using raw value because it is content dependent
const MAX_WIDTH = 830;

/**
 * A presentational component that is shown in cases when there are no data views created yet.
 */
const AddDataPrompt = ({
  addDataHref,
  docLink: docLink
}) => {
  const createDataViewText = _i18n.i18n.translate('indexPatternManagement.addDataPrompt.addDataText', {
    defaultMessage: 'Add data'
  });
  const actions = /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    href: addDataHref,
    iconType: "plusInCircle",
    fill: true,
    "data-test-subj": "createDataViewButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, createDataViewText);
  const title = /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.addDataPrompt.toCreateAddData",
    defaultMessage: "To create a data view, add your data to Elasticsearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
  const body = /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.addDataPrompt.dataViewExplanation",
    defaultMessage: "Data views identify the Elasticsearch data you want to explore. Once you add your data to Elasticsearch, you can point data views to one or more of the created indices, data streams, and index aliases. Add your data now to start searching.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
  const footer = docLink ? /*#__PURE__*/_react2.default.createElement(DocumentationLink, {
    href: docLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 28
    }
  }) : undefined;

  // Load this illustration lazily
  const Illustration = (0, _sharedUxUtility.withSuspense)(/*#__PURE__*/_react2.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-prompt-no-data-views'))).then(({
    DataViewIllustration
  }) => {
    return {
      default: DataViewIllustration
    };
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    css: {
      width: 226,
      height: 206
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "addDataPrompt",
    layout: "horizontal",
    css: (0, _react.css)`
        max-width: ${MAX_WIDTH}px !important; // Necessary to override EuiEmptyPrompt to fit content
        flex-grow: 0;
      `,
    color: "subdued",
    actions,
    title,
    body,
    footer,
    icon: /*#__PURE__*/_react2.default.createElement(Illustration, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  });
};
exports.AddDataPrompt = AddDataPrompt;