"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewFieldOrCreateFromColumnMeta = void 0;
var _lodash = require("lodash");
var _convert_to_data_view_field_spec = require("./convert_to_data_view_field_spec");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDataViewFieldOrCreateFromColumnMeta = ({
  dataView,
  fieldName,
  columnMeta
}) => {
  const dataViewField = dataView.fields.getByName(fieldName);
  if (!columnMeta) {
    return dataViewField;
  }
  const fieldSpecFromColumnMeta = (0, _convert_to_data_view_field_spec.convertDatatableColumnToDataViewFieldSpec)({
    name: fieldName,
    id: fieldName,
    meta: columnMeta
  });
  if (!dataViewField || dataViewField.type !== fieldSpecFromColumnMeta.type || !(0, _lodash.isEqual)(dataViewField.esTypes, fieldSpecFromColumnMeta.esTypes)) {
    return dataView.fields.create(fieldSpecFromColumnMeta);
  }
  return dataViewField;
};
exports.getDataViewFieldOrCreateFromColumnMeta = getDataViewFieldOrCreateFromColumnMeta;