"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexFilterDsl = exports.getFieldByName = exports.findIndexPatternById = void 0;
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @deprecated Use data views api instead
 */
const getFieldByName = (fieldName, indexPattern) => {
  var _indexPattern$attribu;
  const fields = indexPattern && JSON.parse(((_indexPattern$attribu = indexPattern.attributes) === null || _indexPattern$attribu === void 0 ? void 0 : _indexPattern$attribu.fields) || '[]');
  const field = fields && fields.find(f => f.name === fieldName);
  return field;
};

/**
 * @deprecated Use data views api instead
 */
exports.getFieldByName = getFieldByName;
const findIndexPatternById = async (savedObjectsClient, index) => {
  const savedObjectsResponse = await savedObjectsClient.find({
    type: _common.DATA_VIEW_SAVED_OBJECT_TYPE,
    fields: ['fields'],
    search: `"${index}"`,
    searchFields: ['title']
  });
  if (savedObjectsResponse.total > 0) {
    return savedObjectsResponse.saved_objects[0];
  }
};
exports.findIndexPatternById = findIndexPatternById;
const excludeTiersDsl = excludedTiers => {
  const _tier = excludedTiers.split(',').map(tier => tier.trim());
  return {
    bool: {
      must_not: [{
        terms: {
          _tier
        }
      }]
    }
  };
};
const getIndexFilterDsl = ({
  indexFilter,
  excludedTiers
}) => {
  if (!indexFilter) {
    return excludedTiers ? excludeTiersDsl(excludedTiers) : undefined;
  }
  return !excludedTiers ? indexFilter : {
    bool: {
      must: [indexFilter, excludeTiersDsl(excludedTiers)]
    }
  };
};
exports.getIndexFilterDsl = getIndexFilterDsl;