"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onSaveDiscoverSession = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
var _lodash = require("lodash");
var _redux = require("../../../state_management/redux");
var _save_modal = require("./save_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/save_discover_session/on_save_discover_session.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const onSaveDiscoverSession = async ({
  services,
  state,
  initialCopyOnSave,
  onClose,
  onSaveCb
}) => {
  var _persistedDiscoverSes, _persistedDiscoverSes2, _persistedDiscoverSes3, _persistedDiscoverSes4;
  const internalState = state.internalState.getState();
  const persistedDiscoverSession = internalState.persistedDiscoverSession;
  const allTabs = (0, _redux.selectAllTabs)(internalState);
  const timeRestore = (_persistedDiscoverSes = persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.tabs.some(tab => tab.timeRestore)) !== null && _persistedDiscoverSes !== void 0 ? _persistedDiscoverSes : false;
  const isTimeBased = allTabs.some(tab => {
    var _tab$initialInternalS, _tab$initialInternalS2;
    const tabRuntimeState = (0, _redux.selectTabRuntimeState)(state.runtimeStateManager, tab.id);
    const tabDataView = tabRuntimeState.currentDataView$.getValue();
    if (tabDataView) {
      return tabDataView.isTimeBased();
    }
    const tabDataViewIdOrSpec = (_tab$initialInternalS = tab.initialInternalState) === null || _tab$initialInternalS === void 0 ? void 0 : (_tab$initialInternalS2 = _tab$initialInternalS.serializedSearchSource) === null || _tab$initialInternalS2 === void 0 ? void 0 : _tab$initialInternalS2.index;
    if (!tabDataViewIdOrSpec) {
      return false;
    }
    if ((0, _lodash.isObject)(tabDataViewIdOrSpec)) {
      return Boolean(tabDataViewIdOrSpec.timeFieldName);
    }
    const dataViewListItem = internalState.savedDataViews.find(item => item.id === tabDataViewIdOrSpec);
    return Boolean(dataViewListItem === null || dataViewListItem === void 0 ? void 0 : dataViewListItem.timeFieldName);
  });
  const onSave = async ({
    newTitle,
    newCopyOnSave,
    newTimeRestore,
    newDescription,
    newTags,
    isTitleDuplicateConfirmed,
    onTitleDuplicate
  }) => {
    var _response$discoverSes;
    let response = {
      discoverSession: undefined
    };
    try {
      response = await state.internalState.dispatch(_redux.internalStateActions.saveDiscoverSession({
        newTitle,
        newTimeRestore,
        newCopyOnSave,
        newDescription,
        newTags,
        isTitleDuplicateConfirmed,
        onTitleDuplicate
      })).unwrap();
    } catch (error) {
      services.toastNotifications.addDanger({
        title: _i18n.i18n.translate('discover.notifications.notSavedSearchTitle', {
          defaultMessage: `Discover session ''{savedSearchTitle}'' was not saved`,
          values: {
            savedSearchTitle: newTitle
          }
        }),
        text: error.message
      });
    }
    if (response.discoverSession) {
      services.toastNotifications.addSuccess({
        title: _i18n.i18n.translate('discover.notifications.savedSearchTitle', {
          defaultMessage: `Discover session ''{savedSearchTitle}'' was saved`,
          values: {
            savedSearchTitle: newTitle
          }
        }),
        'data-test-subj': 'saveSearchSuccess'
      });
      if (onSaveCb) {
        onSaveCb();
      } else if (response.discoverSession.id !== (persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.id)) {
        var _response;
        services.locator.navigate({
          savedSearchId: response.discoverSession.id,
          ...((_response = response) !== null && _response !== void 0 && _response.nextSelectedTabId ? {
            tab: {
              id: response.nextSelectedTabId
            }
          } : {})
        });
      }
    }
    return {
      id: (_response$discoverSes = response.discoverSession) === null || _response$discoverSes === void 0 ? void 0 : _response$discoverSes.id
    };
  };
  const saveModal = /*#__PURE__*/_react.default.createElement(_save_modal.DiscoverSessionSaveModal, {
    isTimeBased: isTimeBased,
    services: services,
    title: (_persistedDiscoverSes2 = persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.title) !== null && _persistedDiscoverSes2 !== void 0 ? _persistedDiscoverSes2 : '',
    showCopyOnSave: !!(persistedDiscoverSession !== null && persistedDiscoverSession !== void 0 && persistedDiscoverSession.id),
    initialCopyOnSave: initialCopyOnSave,
    description: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.description,
    timeRestore: timeRestore,
    tags: (_persistedDiscoverSes3 = persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.tags) !== null && _persistedDiscoverSes3 !== void 0 ? _persistedDiscoverSes3 : [],
    managed: (_persistedDiscoverSes4 = persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.managed) !== null && _persistedDiscoverSes4 !== void 0 ? _persistedDiscoverSes4 : false,
    onSave: onSave,
    onClose: onClose !== null && onClose !== void 0 ? onClose : () => {},
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  });
  (0, _public.showSaveModal)(saveModal);
};
exports.onSaveDiscoverSession = onSaveDiscoverSession;