"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataGridColumnsConfiguration = exports.createCustomCellRenderer = void 0;
var _unifiedDataTable = require("@kbn/unified-data-table");
var _summary_column = require("../../../../components/data_types/logs/summary_column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDataGridColumnsConfiguration = params => {
  return {
    customCellRenderer: createCustomCellRenderer(params)
  };
};
exports.getDataGridColumnsConfiguration = getDataGridColumnsConfiguration;
const createCustomCellRenderer = params => {
  return {
    [_unifiedDataTable.SOURCE_COLUMN]: (0, _summary_column.getSummaryColumn)(params)
  };
};
exports.createCustomCellRenderer = createCustomCellRenderer;