"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentProfileTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _document_json_display = require("./document_json_display");
var _get_expand_action = require("./get_expand_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/discover/public/context_awareness/inspector/profiles_inspector_view/document_profiles_section/document_profile_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DocumentProfileTable = ({
  profileId,
  records,
  onViewRecordDetails
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [expandedRecord, setExpandedRecord] = (0, _react.useState)(undefined);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfileTableCaption', {
      defaultMessage: 'Records with document profile ID {profileId}',
      values: {
        profileId
      }
    }),
    items: records,
    itemId: "id",
    pagination: true,
    columns: [{
      name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfileIdColumn', {
        defaultMessage: 'Record ID'
      }),
      render: record => {
        var _record$raw$_id;
        return (_record$raw$_id = record.raw._id) !== null && _record$raw$_id !== void 0 ? _record$raw$_id : record.id;
      }
    }, {
      field: 'context.type',
      name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfileTypeColumn', {
        defaultMessage: 'Type'
      })
    }, {
      name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfileActionsColumn', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfileDetailsAction', {
          defaultMessage: 'View details'
        }),
        description: _i18n.i18n.translate('discover.inspector.profilesInspectorView.documentProfileDetailsActionDescription', {
          defaultMessage: 'View record details'
        }),
        'data-test-subj': 'documentProfileTableInspectAction',
        icon: 'inspect',
        type: 'icon',
        onClick: record => {
          onViewRecordDetails(record);
        }
      }, (0, _get_expand_action.getExpandAction)({
        name: _i18n.i18n.translate('discover.inspector.profilesInspectorView.viewDocumentDetails', {
          defaultMessage: 'View record details'
        }),
        description: _i18n.i18n.translate('discover.inspector.profilesInspectorView.viewDocumentDetailsDescription', {
          defaultMessage: 'Expand to view the document JSON'
        }),
        'data-test-subj': 'documentProfileTableExpandAction',
        isExpanded: value => (expandedRecord === null || expandedRecord === void 0 ? void 0 : expandedRecord.id) === value.id,
        onClick: value => setExpandedRecord(value)
      })]
    }],
    itemIdToExpandedRowMap: expandedRecord ? {
      [expandedRecord.id]: /*#__PURE__*/_react.default.createElement(_document_json_display.DocumentJsonDisplay, {
        record: expandedRecord,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 36
        }
      })
    } : undefined,
    css: {
      table: {
        border: euiTheme.border.thin
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
};
exports.DocumentProfileTable = DocumentProfileTable;