"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleSourceColumnState = handleSourceColumnState;
var _lodash = require("lodash");
var _discoverUtils = require("@kbn/discover-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Makes sure the current state is not referencing the source column when using the fields api
 * @param state
 * @param uiSettings
 */
function handleSourceColumnState(state, uiSettings) {
  if (!state.columns) {
    return state;
  }
  const defaultColumns = uiSettings.get(_discoverUtils.DEFAULT_COLUMNS_SETTING);

  // filter out the source column
  let cleanedColumns = state.columns.filter(column => column !== '_source');
  if (cleanedColumns.length === 0 && !(0, _lodash.isEqual)(defaultColumns, ['_source'])) {
    cleanedColumns = defaultColumns;
    // defaultColumns could still contain _source
    cleanedColumns = cleanedColumns.filter(column => column !== '_source');
  }
  return {
    ...state,
    columns: cleanedColumns
  };
}