"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogLevelColor = void 0;
var _eui = require("@elastic/eui");
var _get_log_level_coalesed_value = require("./get_log_level_coalesed_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getLogLevelColor = (logLevelCoalescedValue, euiTheme) => {
  const euiPaletteForTemperature6 = (0, _eui.euiPaletteForTemperature)(6);
  const euiPaletteForStatus9 = (0, _eui.euiPaletteForStatus)(9);
  const euiPaletteRed9 = (0, _eui.euiPaletteRed)(14);
  switch (logLevelCoalescedValue) {
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.trace:
      return euiTheme.colors.mediumShade;
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.debug:
      return euiPaletteForTemperature6[2];
    // lighter, closer to the default color for all other unknown log levels
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.info:
      return euiPaletteForTemperature6[1];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.notice:
      return euiPaletteForTemperature6[0];
    // darker as it has higher importance than "debug" and "info"
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.warning:
      return euiPaletteForStatus9[4];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.error:
      return euiPaletteRed9[9];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.critical:
      return euiPaletteRed9[10];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.alert:
      return euiPaletteRed9[11];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.emergency:
      return euiPaletteRed9[12];
    case _get_log_level_coalesed_value.LogLevelCoalescedValue.fatal:
      return euiPaletteRed9[13];
    default:
      return euiTheme.colors.mediumShade;
  }
};
exports.getLogLevelColor = getLogLevelColor;