"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePager = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const usePager = ({
  initialPageSize,
  totalItems
}) => {
  const [pageSize, setPageSize] = (0, _react.useState)(initialPageSize);
  // zero based index, if curPageIndex is set to 1, it will represent the second page.
  const [curPageIndex, setCurPageIndex] = (0, _react.useState)(0);
  const meta = (0, _react.useMemo)(() => {
    const totalPages = Math.ceil(totalItems / pageSize);
    return {
      totalPages,
      startIndex: pageSize * curPageIndex,
      hasNextPage: curPageIndex + 1 < totalPages
    };
  }, [curPageIndex, pageSize, totalItems]);
  const changePageIndex = (0, _react.useCallback)(pageIndex => setCurPageIndex(pageIndex), []);
  const changePageSize = (0, _react.useCallback)(newPageSize => setPageSize(newPageSize), []);

  /**
   * Go to the first page if the current is no longer available
   */
  (0, _react.useEffect)(() => {
    if (meta.totalPages < curPageIndex + 1) {
      changePageIndex(0);
    }
  }, [curPageIndex, meta.totalPages, changePageIndex]);
  return (0, _react.useMemo)(() => ({
    ...meta,
    curPageIndex,
    pageSize,
    changePageIndex,
    changePageSize
  }), [changePageIndex, changePageSize, curPageIndex, meta, pageSize]);
};
exports.usePager = usePager;