"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlattenedTraceDocumentOverview = getFlattenedTraceDocumentOverview;
exports.getTraceDocumentOverview = getTraceDocumentOverview;
var _apmTypes = require("@kbn/apm-types");
var _get_formatted_fields = require("./get_formatted_fields");
var _get_flattened_fields = require("./get_flattened_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fields = [_apmTypes.AT_TIMESTAMP, _apmTypes.PARENT_ID, _apmTypes.HTTP_RESPONSE_STATUS_CODE, _apmTypes.TRACE_ID, _apmTypes.SERVICE_NAME, _apmTypes.SERVICE_ENVIRONMENT, _apmTypes.AGENT_NAME, _apmTypes.TRANSACTION_ID, _apmTypes.TRANSACTION_NAME, _apmTypes.TRANSACTION_DURATION, _apmTypes.TRANSACTION_TYPE, _apmTypes.USER_AGENT_NAME, _apmTypes.USER_AGENT_VERSION, _apmTypes.SPAN_NAME, _apmTypes.SPAN_ID, _apmTypes.SPAN_ACTION, _apmTypes.SPAN_DURATION, _apmTypes.SPAN_TYPE, _apmTypes.SPAN_SUBTYPE, _apmTypes.SPAN_DESTINATION_SERVICE_RESOURCE, _apmTypes.USER_AGENT_NAME, _apmTypes.USER_AGENT_VERSION, _apmTypes.PROCESSOR_EVENT, _apmTypes.DURATION, _apmTypes.KIND, _apmTypes.RESOURCE_ATTRIBUTES_TELEMETRY_SDK_LANGUAGE, _apmTypes.SPAN_LINKS_SPAN_ID, _apmTypes.SPAN_LINKS_TRACE_ID, _apmTypes.LINKS_SPAN_ID, _apmTypes.LINKS_TRACE_ID];
function getTraceDocumentOverview(doc, {
  dataView,
  fieldFormats
}) {
  return (0, _get_formatted_fields.getFormattedFields)(doc, fields, {
    dataView,
    fieldFormats
  });
}
function getFlattenedTraceDocumentOverview(doc) {
  return (0, _get_flattened_fields.getFlattenedFields)(doc, fields);
}