"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityAlertsPageReference = exports.securityAlertReference = exports.productDocumentationReference = exports.knowledgeBaseReference = exports.hrefReference = exports.esqlQueryReference = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generates a contentReference for the alerts count tool.
 * @param id id of the contentReference
 * @returns AlertsCountReference
 */
const securityAlertsPageReference = id => {
  return {
    type: 'SecurityAlertsPage',
    id
  };
};

/**
 * Generates a contentReference for when a specific alert is referenced.
 * @param id id of the contentReference
 * @param alertId id of the alert that is referenced
 * @returns AlertReference
 */
exports.securityAlertsPageReference = securityAlertsPageReference;
const securityAlertReference = (id, alertId) => {
  return {
    type: 'SecurityAlert',
    id,
    alertId
  };
};

/**
 * Generates a contentReference for when a knowledge base entry is referenced.
 * @param id id of the contentReference
 * @param knowledgeBaseEntryName name of the knowledge base entry
 * @param knowledgeBaseEntryId id of the knowledge base entry
 * @returns KnowledgeBaseReference
 */
exports.securityAlertReference = securityAlertReference;
const knowledgeBaseReference = (id, knowledgeBaseEntryName, knowledgeBaseEntryId) => {
  return {
    type: 'KnowledgeBaseEntry',
    id,
    knowledgeBaseEntryName,
    knowledgeBaseEntryId
  };
};

/**
 * Generates a contentReference for when a external page is referenced.
 * @param id id of the contentReference
 * @param href the external page url
 * @param label content reference label
 * @returns HrefContentReference
 */
exports.knowledgeBaseReference = knowledgeBaseReference;
const hrefReference = (id, href, label) => {
  return {
    type: 'Href',
    id,
    href,
    label
  };
};

/**
 * Generates a contentReference for when a ESQL query is referenced.
 * @param id id of the contentReference
 * @param query the ESQL query
 * @param label content reference label
 * @returns KnowledgeBaseReference
 */
exports.hrefReference = hrefReference;
const esqlQueryReference = params => {
  return {
    type: 'EsqlQuery',
    ...params
  };
};

/**
 * Generates a contentReference for the alerts count tool.
 * @param id id of the contentReference
 * @returns AlertsCountReference
 */
exports.esqlQueryReference = esqlQueryReference;
const productDocumentationReference = (id, title, url) => {
  return {
    type: 'ProductDocumentation',
    id,
    title,
    url
  };
};
exports.productDocumentationReference = productDocumentationReference;