"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizedData = void 0;
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnonymizedData = ({
  anonymizationFields,
  currentReplacements,
  getAnonymizedValue,
  getAnonymizedValues,
  rawData
}) => Object.keys(rawData).reduce((acc, field) => {
  if ((0, _helpers.isAllowed)({
    anonymizationFields: anonymizationFields !== null && anonymizationFields !== void 0 ? anonymizationFields : [],
    field
  })) {
    const {
      anonymizedValues,
      replacements
    } = getAnonymizedValues({
      anonymizationFields,
      currentReplacements,
      field,
      getAnonymizedValue,
      rawData
    });
    return {
      anonymizedData: {
        ...acc.anonymizedData,
        [field]: anonymizedValues
      },
      replacements: {
        ...acc.replacements,
        ...replacements
      }
    };
  } else {
    return acc;
  }
}, {
  anonymizedData: {},
  replacements: {}
});
exports.getAnonymizedData = getAnonymizedData;