"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttackDiscoveryScheduleActionsPropsFromApi = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isGeneralAction = action => {
  return Object.hasOwn(action, 'group');
};
const transformAttackDiscoveryScheduleActionsPropsFromApi = actions => {
  return actions === null || actions === void 0 ? void 0 : actions.map(action => {
    if (isGeneralAction(action)) {
      return {
        actionTypeId: action.action_type_id,
        group: action.group,
        id: action.id,
        params: action.params,
        uuid: action.uuid,
        alertsFilter: action.alerts_filter,
        frequency: action.frequency ? {
          summary: action.frequency.summary,
          notifyWhen: action.frequency.notify_when,
          throttle: action.frequency.throttle
        } : undefined
      };
    }
    return {
      actionTypeId: action.action_type_id,
      id: action.id,
      params: action.params,
      uuid: action.uuid
    };
  });
};
exports.transformAttackDiscoveryScheduleActionsPropsFromApi = transformAttackDiscoveryScheduleActionsPropsFromApi;