"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreatedAttackDiscoveryAlerts = void 0;
var _fp = require("lodash/fp");
var _get_ids_query = require("./get_ids_query");
var _transform_search_response_to_alerts = require("../../transforms/transform_search_response_to_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCreatedAttackDiscoveryAlerts = async ({
  attackDiscoveryAlertsIndex,
  createdDocumentIds,
  enableFieldRendering,
  logger,
  readDataClient,
  withReplacements
}) => {
  if ((0, _fp.isEmpty)(createdDocumentIds)) {
    logger.debug(() => `No Attack discovery alerts to query in index ${attackDiscoveryAlertsIndex} (getCreatedAttackDiscoveryAlerts)`);
    return [];
  }
  try {
    const idsQuery = (0, _get_ids_query.getIdsQuery)(createdDocumentIds);

    // For some reason inside the rule data client we cast the response from `estypes.SearchResponse`
    // into the ` as unknown as ESSearchResponse<TAlertDoc, TSearchRequest>`.
    // Within the attack discovery we work with the `estypes` and thus here we cast response back.
    const response = await readDataClient.search({
      size: createdDocumentIds.length,
      ...idsQuery
    });
    const {
      data
    } = (0, _transform_search_response_to_alerts.transformSearchResponseToAlerts)({
      enableFieldRendering,
      logger,
      response,
      withReplacements
    });
    return data;
  } catch (err) {
    logger.error(`Error getting created Attack discovery alerts in index ${attackDiscoveryAlertsIndex}: ${err} with alert ids: ${createdDocumentIds.join(', ')}`);
    throw err;
  }
};
exports.getCreatedAttackDiscoveryAlerts = getCreatedAttackDiscoveryAlerts;