"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefendInsightsIncompatibleAntiVirusGenerationSchema = getDefendInsightsIncompatibleAntiVirusGenerationSchema;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefendInsightsIncompatibleAntiVirusGenerationSchema(prompts) {
  return _zod.z.object({
    insights: _zod.z.array(_zod.z.object({
      group: _zod.z.string().describe(prompts.group),
      events: _zod.z.object({
        id: _zod.z.string().describe(prompts.eventsId),
        endpointId: _zod.z.string().describe(prompts.eventsEndpointId),
        value: _zod.z.string().describe(prompts.eventsValue)
      }).array().describe(prompts.events)
    }))
  });
}