"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultGraphState = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultGraphState = ({
  start,
  end,
  prompts
}) => ({
  insights: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => null
  },
  prompt: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => prompts.default
  },
  refinePrompt: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => prompts.refine
  },
  continuePrompt: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => prompts.continue
  },
  anonymizedDocuments: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => []
  },
  combinedGenerations: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => ''
  },
  combinedRefinements: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => ''
  },
  errors: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => []
  },
  generationAttempts: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => 0
  },
  generations: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => []
  },
  hallucinationFailures: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => 0
  },
  maxGenerationAttempts: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => _constants.DEFAULT_MAX_GENERATION_ATTEMPTS
  },
  maxHallucinationFailures: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => _constants.DEFAULT_MAX_HALLUCINATION_FAILURES
  },
  maxRepeatedGenerations: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => _constants.DEFAULT_MAX_REPEATED_GENERATIONS
  },
  refinements: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => []
  },
  replacements: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => ({})
  },
  unrefinedResults: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => null
  },
  start: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => start
  },
  end: {
    value: (current, next) => next !== null && next !== void 0 ? next : current,
    default: () => end
  }
});
exports.getDefaultGraphState = getDefaultGraphState;