"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sorting = exports.SearchBar = exports.ResultsView = exports.ResultsPerPageView = exports.ResultView = exports.RESULTS_PER_PAGE_OPTIONS = exports.PagingInfoView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _reactSearchUi = require("@elastic/react-search-ui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _health_colors = require("../../../../shared/constants/health_colors");
var _search_application_view_logic = require("../search_application_view_logic");
var _convert_results = require("./convert_results");
var _document_context = require("./document_context");
var _field_value_cell = require("./field_value_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/docs_explorer/search_ui_components.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ResultsView = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  }, children);
};
exports.ResultsView = ResultsView;
const RESULT_FIELDS_TRUNCATE_AT = 4;
const ResultView = ({
  result
}) => {
  var _searchApplicationDat;
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    setSelectedDocument
  } = (0, _document_context.useSelectedDocument)();
  const {
    fields,
    index
  } = (0, _convert_results.convertResultToFieldsAndIndex)(result);
  const id = result._meta.rawHit.__id;
  const truncatedFields = fields.slice(0, RESULT_FIELDS_TRUNCATE_AT);
  const hiddenFields = fields.length - truncatedFields.length;
  const indexHealth = searchApplicationData === null || searchApplicationData === void 0 ? void 0 : (_searchApplicationDat = searchApplicationData.indices.find(i => i.name === index)) === null || _searchApplicationDat === void 0 ? void 0 : _searchApplicationDat.health;
  const badgeColor = !indexHealth || indexHealth === 'unknown' ? 'hollow' : (0, _health_colors.indexHealthToHealthColor)(indexHealth);
  const columns = [{
    field: 'field',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.result.nameColumn', {
      defaultMessage: 'Field'
    }),
    render: field => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 15
        }
      }, "\"", field, "\"")));
    },
    truncateText: true,
    width: '20%'
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.result.valueColumn', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_field_value_cell.FieldValueCell, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    })))
  }];
  return /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: () => setSelectedDocument(result),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.result.id",
    defaultMessage: "ID: {id}",
    values: {
      id
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.result.fromIndex",
    defaultMessage: "from",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 17
    }
  }, index)))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: truncatedFields,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), hiddenFields > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowRight",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.result.moreFieldsButton",
    defaultMessage: "{count} {count, plural, one {More Field} other {More Fields}}",
    values: {
      count: hiddenFields
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 19
    }
  })))))));
};
exports.ResultView = ResultView;
const SearchBar = ({
  additionalInputProps
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 153,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, (0, _extends2.default)({
  fullWidth: true
}, additionalInputProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 154,
    columnNumber: 5
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  type: "submit",
  color: "primary",
  fill: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 155,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.inputView.searchLabel', {
  defaultMessage: 'Search'
})));
exports.SearchBar = SearchBar;
const PagingInfoView = ({
  start,
  end,
  totalResults
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 166,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  tagName: "p",
  id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.pagingInfo.text",
  defaultMessage: "Showing <strong>{start}-{end}</strong> of {totalResults}",
  values: {
    end,
    start,
    strong: chunks => /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 46
      }
    }, chunks),
    totalResults
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 167,
    columnNumber: 5
  }
}));
exports.PagingInfoView = PagingInfoView;
const RESULTS_PER_PAGE_OPTIONS = exports.RESULTS_PER_PAGE_OPTIONS = [10, 20, 50];
const ResultsPerPageView = ({
  onChange,
  options,
  value
}) => {
  var _options$map;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 3
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "results-per-page",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.resultsPerPage.label",
    defaultMessage: "Show",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "results-per-page",
    options: (_options$map = options === null || options === void 0 ? void 0 : options.map(option => ({
      text: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.resultsPerPage.option.label', {
        defaultMessage: '{value} {value, plural, one {Result} other {Results}}',
        values: {
          value: option
        }
      }),
      value: option
    }))) !== null && _options$map !== void 0 ? _options$map : [],
    value: value,
    onChange: evt => onChange(parseInt(evt.target.value, 10)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  })));
};
exports.ResultsPerPageView = ResultsPerPageView;
const Sorting = exports.Sorting = (0, _reactSearchUi.withSearch)(({
  setSort,
  sortList
}) => ({
  setSort,
  sortList
}))(({
  sortableFields,
  sortList,
  setSort
}) => {
  const [{
    direction,
    field
  }] = !(sortList !== null && sortList !== void 0 && sortList.length) ? [{
    direction: '',
    field: ''
  }] : sortList;
  const relevance = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.sortingView.relevanceLabel', {
    defaultMessage: 'Relevance'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "sorting-field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.sortingView.fieldLabel",
    defaultMessage: "Sort By",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: "sorting-field",
    isClearable: false,
    singleSelection: {
      asPlainText: true
    },
    options: [{
      label: relevance,
      value: ''
    }, ...sortableFields.map(f => ({
      label: f,
      value: f
    }))],
    selectedOptions: [{
      label: !!field ? field : relevance,
      value: field
    }],
    onChange: ([{
      value
    }]) => setSort(value === '' ? [] : [{
      direction: 'asc',
      field: value
    }], 'asc'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  })), field !== '' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "sorting-direction",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.sortingView.directionLabel",
    defaultMessage: "Order By",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "sorting-direction",
    onChange: evt => {
      switch (evt.target.value) {
        case 'asc':
          return setSort([{
            direction: 'asc',
            field
          }], 'asc');
        case 'desc':
          return setSort([{
            direction: 'desc',
            field
          }], 'desc');
      }
    },
    value: direction,
    options: [{
      text: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.sortingView.ascLabel', {
        defaultMessage: 'Ascending'
      }),
      value: 'asc'
    }, {
      text: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.docsExplorer.sortingView.descLabel', {
        defaultMessage: 'Descending'
      }),
      value: 'desc'
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 13
    }
  }))));
});