"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _delete_connector_api_logic = require("../../api/connector/delete_connector_api_logic");
var _fetch_connectors = require("../../api/connector/fetch_connectors.api");
var _delete_index_api_logic = require("../../api/index/delete_index_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorsLogic = exports.ConnectorsLogic = (0, _kea.kea)({
  actions: {
    closeDeleteModal: true,
    fetchConnectors: ({
      fetchCrawlersOnly,
      from,
      size,
      searchQuery
    }) => ({
      fetchCrawlersOnly,
      from,
      searchQuery,
      size
    }),
    onPaginate: newPageIndex => ({
      newPageIndex
    }),
    openDeleteModal: (connectorName, connectorId, indexName) => ({
      connectorId,
      connectorName,
      indexName
    }),
    setIsFirstRequest: true
  },
  connect: {
    actions: [_delete_connector_api_logic.DeleteConnectorApiLogic, ['apiError as deleteError', 'apiSuccess as deleteSuccess', 'makeRequest as deleteConnector'], _delete_index_api_logic.DeleteIndexApiLogic, ['apiError as deleteIndexError', 'apiSuccess as deleteIndexSuccess', 'makeRequest as deleteIndex'], _fetch_connectors.FetchConnectorsApiLogic, ['makeRequest', 'apiSuccess', 'apiError']],
    values: [_delete_connector_api_logic.DeleteConnectorApiLogic, ['status as deleteStatus'], _delete_index_api_logic.DeleteIndexApiLogic, ['status as deleteIndexStatus'], _fetch_connectors.FetchConnectorsApiLogic, ['data', 'status']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    deleteSuccess: () => {
      actions.closeDeleteModal();
      actions.makeRequest(values.searchParams);
    },
    deleteIndexSuccess: () => {
      actions.closeDeleteModal();
      actions.makeRequest(values.searchParams);
    },
    fetchConnectors: async (input, breakpoint) => {
      await breakpoint(150);
      actions.makeRequest(input);
    }
  }),
  path: ['enterprise_search', 'content', 'connectors_logic'],
  reducers: () => ({
    deleteModalConnectorId: ['', {
      closeDeleteModal: () => '',
      openDeleteModal: (_, {
        connectorId
      }) => connectorId
    }],
    deleteModalConnectorName: ['', {
      closeDeleteModal: () => '',
      openDeleteModal: (_, {
        connectorName
      }) => connectorName
    }],
    deleteModalIndexName: [null, {
      closeDeleteModal: () => null,
      openDeleteModal: (_, {
        indexName
      }) => indexName
    }],
    isDeleteModalVisible: [false, {
      closeDeleteModal: () => false,
      openDeleteModal: () => true
    }],
    isFirstRequest: [true, {
      apiError: () => false,
      apiSuccess: () => false,
      setIsFirstRequest: () => true
    }],
    searchParams: [{
      fetchCrawlersOnly: false,
      from: 0,
      searchQuery: '',
      size: 10
    }, {
      apiSuccess: ({
        fetchCrawlersOnly,
        searchQuery
      }, {
        meta
      }) => ({
        fetchCrawlersOnly,
        from: meta.page.from,
        searchQuery,
        size: meta.page.size
      }),
      fetchConnectors: (state, payload) => ({
        ...state,
        ...payload
      }),
      onPaginate: (state, {
        newPageIndex
      }) => ({
        ...state,
        from: (newPageIndex - 1) * state.size
      })
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    connectors: [() => [selectors.data], data => {
      return (data === null || data === void 0 ? void 0 : data.connectors.map(connector => {
        const indexName = connector.index_name;
        if (indexName) {
          return {
            ...connector,
            docsCount: data === null || data === void 0 ? void 0 : data.counts[indexName],
            indexExists: data === null || data === void 0 ? void 0 : data.indexExists[indexName]
          };
        }
        return connector;
      })) || [];
    }],
    isDeleteLoading: [() => [selectors.deleteStatus, selectors.deleteIndexStatus], (deleteStatus, deleteIndexStatus) => _api.Status.LOADING === deleteStatus || _api.Status.LOADING === deleteIndexStatus],
    isEmpty: [() => [selectors.data], data => {
      var _ref;
      return (_ref = (data === null || data === void 0 ? void 0 : data.isInitialRequest) && (data === null || data === void 0 ? void 0 : data.connectors) && data.connectors.length === 0) !== null && _ref !== void 0 ? _ref : false;
    }],
    isLoading: [() => [selectors.status, selectors.isFirstRequest], (status, isFirstRequest) => [_api.Status.LOADING, _api.Status.IDLE].includes(status) && isFirstRequest],
    meta: [() => [selectors.data], data => {
      var _data$meta;
      return (_data$meta = data === null || data === void 0 ? void 0 : data.meta) !== null && _data$meta !== void 0 ? _data$meta : {
        page: {
          from: 0,
          size: 20,
          total: 0
        }
      };
    }]
  })
});