"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateEntitiesLatestIndexTemplateConfig = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _generate_component_id = require("../helpers/generate_component_id");
var _constants_entities = require("../../../../common/constants_entities");
var _is_builtin_definition = require("../helpers/is_builtin_definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateEntitiesLatestIndexTemplateConfig = definition => ({
  name: (0, _generate_component_id.generateLatestIndexTemplateId)(definition),
  _meta: {
    description: "Index template for indices managed by the Elastic Entity Model's entity discovery framework for the latest dataset",
    ecs_version: '8.0.0',
    managed: true,
    managed_by: 'security_context_core_analysis'
  },
  ignore_missing_component_templates: getCustomLatestTemplateComponents(definition),
  composed_of: [_constants_entities.ECS_MAPPINGS_COMPONENT_TEMPLATE, _constants_entities.ENTITY_LATEST_BASE_COMPONENT_TEMPLATE_V1, _constants_entities.ENTITY_ENTITY_COMPONENT_TEMPLATE_V1, _constants_entities.ENTITY_EVENT_COMPONENT_TEMPLATE_V1, ...getCustomLatestTemplateComponents(definition)],
  index_patterns: [(0, _entitiesSchema.entitiesIndexPattern)({
    schemaVersion: _entitiesSchema.ENTITY_SCHEMA_VERSION_V1,
    dataset: _entitiesSchema.ENTITY_LATEST,
    definitionId: definition.id
  })],
  priority: 200,
  template: {
    aliases: {
      [(0, _entitiesSchema.entitiesAliasPattern)({
        type: definition.type,
        dataset: _entitiesSchema.ENTITY_LATEST
      })]: {}
    },
    mappings: {
      _meta: {
        version: '1.6.0'
      },
      date_detection: false,
      dynamic_templates: [{
        strings_as_keyword: {
          mapping: {
            ignore_above: 1024,
            type: 'keyword',
            fields: {
              text: {
                type: 'text'
              }
            }
          },
          match_mapping_type: 'string'
        }
      }, {
        entity_metrics: {
          mapping: {
            type: '{dynamic_type}'
          },
          match_mapping_type: ['long', 'double'],
          path_match: 'entity.metrics.*'
        }
      }]
    },
    settings: {
      index: {
        codec: 'best_compression',
        mapping: {
          total_fields: {
            limit: 2000
          }
        }
      }
    }
  }
});
exports.generateEntitiesLatestIndexTemplateConfig = generateEntitiesLatestIndexTemplateConfig;
function getCustomLatestTemplateComponents(definition) {
  if ((0, _is_builtin_definition.isBuiltinDefinition)(definition)) {
    return [];
  }
  return [`${definition.id}@platform`,
  // @platform goes before so it can be overwritten by custom
  `${definition.id}-latest@platform`, `${definition.id}@custom`, `${definition.id}-latest@custom`];
}