"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewFieldSubtypeMulti = getDataViewFieldSubtypeMulti;
exports.getDataViewFieldSubtypeNested = getDataViewFieldSubtypeNested;
exports.getTimeZoneFromSettings = getTimeZoneFromSettings;
exports.isCCSRemoteIndexName = isCCSRemoteIndexName;
exports.isDataViewFieldSubtypeMulti = isDataViewFieldSubtypeMulti;
exports.isDataViewFieldSubtypeNested = isDataViewFieldSubtypeNested;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */
function getTimeZoneFromSettings(dateFormatTZ) {
  const detectedTimezone = _momentTimezone.default.tz.guess();
  return dateFormatTZ === 'Browser' ? detectedTimezone : dateFormatTZ;
}
function isDataViewFieldSubtypeNested(field) {
  var _subTypeNested$nested;
  const subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$nested = subTypeNested.nested) !== null && _subTypeNested$nested !== void 0 && _subTypeNested$nested.path);
}
function getDataViewFieldSubtypeNested(field) {
  return isDataViewFieldSubtypeNested(field) ? field.subType : undefined;
}
function isDataViewFieldSubtypeMulti(field) {
  var _subTypeNested$multi;
  const subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$multi = subTypeNested.multi) !== null && _subTypeNested$multi !== void 0 && _subTypeNested$multi.parent);
}
function getDataViewFieldSubtypeMulti(field) {
  return isDataViewFieldSubtypeMulti(field) ? field.subType : undefined;
}

/**
 * Check whether the index expression represents a remote index (CCS) or not.
 * The index name is assumed to be individual index (no commas) but can contain `-`, wildcards,
 * datemath, remote cluster name and any other syntax permissible in index expression component.
 *
 * 2025/01/21 Implementation taken from https://github.com/smalyshev/elasticsearch/blob/main/server/src/main/java/org/elasticsearch/transport/RemoteClusterAware.java
 *
 * @param indexExpression
 */
function isCCSRemoteIndexName(indexExpression) {
  if (indexExpression === '' || indexExpression[0] === '<' || indexExpression.startsWith('-<')) {
    // This is date math, but even if it is not, the remote can't start with '<'.
    // Thus, whatever it is, this is definitely not a remote index.
    return false;
  }
  const idx = indexExpression.indexOf(':');
  // Check to make sure the remote cluster separator ':' isn't actually a selector separator '::'
  const isSelector = indexExpression.startsWith('::', idx);

  // Note remote index name also can not start with ':'
  return idx > 0 && !isSelector;
}