"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../../complete_items");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _expressions = require("../../../definitions/utils/expressions");
var _types = require("../../types");
var _is = require("../../../ast/is");
var _functions = require("../../../definitions/utils/autocomplete/functions");
var _ast = require("../../../definitions/utils/ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType)) {
    return [];
  }
  const innerText = query.substring(0, cursorPosition);
  let expressionRoot = /,\s*$/.test(innerText) ? undefined : command.args[command.args.length - 1];
  let insideAssignment = false;
  if (expressionRoot && (0, _is.isAssignment)(expressionRoot)) {
    // EVAL foo = <use this as the expression root>
    expressionRoot = expressionRoot.args[1][0];
    insideAssignment = true;
    if ((0, _ast.isMarkerNode)(expressionRoot)) {
      expressionRoot = undefined;
    }
  }
  const suggestions = await (0, _helpers.suggestForExpression)({
    innerText,
    getColumnsByType: callbacks === null || callbacks === void 0 ? void 0 : callbacks.getByType,
    expressionRoot,
    location: _types.Location.EVAL,
    context,
    hasMinimumLicenseRequired: callbacks === null || callbacks === void 0 ? void 0 : callbacks.hasMinimumLicenseRequired,
    activeProduct: context === null || context === void 0 ? void 0 : context.activeProduct
  });
  const positionInExpression = (0, _helpers.getExpressionPosition)(query, expressionRoot);
  if (positionInExpression === 'empty_expression' && !insideAssignment) {
    var _callbacks$getSuggest;
    suggestions.push((0, _complete_items.getNewUserDefinedColumnSuggestion)((callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getSuggest = callbacks.getSuggestedUserDefinedColumnName) === null || _callbacks$getSuggest === void 0 ? void 0 : _callbacks$getSuggest.call(callbacks)) || ''));
  }
  const functionsSpecificSuggestions = await (0, _functions.getInsideFunctionsSuggestions)(innerText, cursorPosition, callbacks, context);
  if (functionsSpecificSuggestions) {
    return functionsSpecificSuggestions;
  }
  if (
  // don't suggest finishing characters if incomplete expression
  (0, _expressions.isExpressionComplete)((0, _expressions.getExpressionType)(expressionRoot, context === null || context === void 0 ? void 0 : context.columns), innerText) &&
  // don't suggest finishing characters if the expression is a column
  // because "EVAL columnName" is a useless expression
  expressionRoot && (!(0, _is.isColumn)(expressionRoot) || insideAssignment)) {
    suggestions.push(_complete_items.pipeCompleteItem, {
      ..._complete_items.commaCompleteItem,
      text: ', '
    });
  }
  return suggestions;
}