"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../../complete_items");
var _types = require("../../types");
var _utils = require("../../../definitions/utils");
var _shared = require("../../../definitions/utils/shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  var _callbacks$getSuggest;
  const innerText = query.substring(0, cursorPosition);
  // ROW col0 = /
  if (/=\s*$/.test(innerText)) {
    return (0, _utils.getFunctionSuggestions)({
      location: _types.Location.ROW
    }, callbacks === null || callbacks === void 0 ? void 0 : callbacks.hasMinimumLicenseRequired, context === null || context === void 0 ? void 0 : context.activeProduct);
  }

  // ROW col0 = 23 /
  else if (command.args.length > 0 && !(0, _shared.isRestartingExpression)(innerText)) {
    return [(0, _helpers.withAutoSuggest)(_complete_items.pipeCompleteItem), (0, _helpers.withAutoSuggest)({
      ..._complete_items.commaCompleteItem,
      text: ', '
    })];
  }

  // ROW /
  // ROW foo = "bar", /
  return [(0, _complete_items.getNewUserDefinedColumnSuggestion)((callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getSuggest = callbacks.getSuggestedUserDefinedColumnName) === null || _callbacks$getSuggest === void 0 ? void 0 : _callbacks$getSuggest.call(callbacks)) || ''), ...(0, _utils.getFunctionSuggestions)({
    location: _types.Location.ROW
  }, callbacks === null || callbacks === void 0 ? void 0 : callbacks.hasMinimumLicenseRequired, context === null || context === void 0 ? void 0 : context.activeProduct)];
}