"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlService = void 0;
var _utils = require("../lookup/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EsqlService {
  constructor(options) {
    this.options = options;
  }
  async getIndicesByIndexMode(mode, remoteClusters) {
    var _sources$indices, _sources$data_streams;
    const {
      client
    } = this.options;
    const indices = [];
    const sourcesToQuery = ['*'];
    const remoteClustersArray = [];
    if (remoteClusters) {
      remoteClustersArray.push(...remoteClusters.split(','));
      // attach a wildcard * for each remoteCluster
      const clustersArray = remoteClustersArray.map(cluster => `${cluster.trim()}:*`);
      sourcesToQuery.push(...clustersArray);
    }

    // It doesn't return hidden indices
    const sources = await client.indices.resolveIndex({
      name: sourcesToQuery,
      expand_wildcards: 'open',
      querystring: {
        mode
      }
    });
    (_sources$indices = sources.indices) === null || _sources$indices === void 0 ? void 0 : _sources$indices.forEach(index => {
      var _index$aliases;
      indices.push({
        name: index.name,
        mode,
        aliases: (_index$aliases = index.aliases) !== null && _index$aliases !== void 0 ? _index$aliases : []
      });
    });
    (_sources$data_streams = sources.data_streams) === null || _sources$data_streams === void 0 ? void 0 : _sources$data_streams.forEach(dataStream => {
      var _dataStream$aliases;
      indices.push({
        name: dataStream.name,
        mode,
        aliases: (_dataStream$aliases = dataStream.aliases) !== null && _dataStream$aliases !== void 0 ? _dataStream$aliases : []
      });
    });
    const crossClusterCommonIndices = remoteClusters ? (0, _utils.getListOfCCSIndices)(remoteClustersArray, indices) : indices;
    const result = {
      indices: crossClusterCommonIndices
    };
    return result;
  }
  async getInferenceEndpoints(taskType) {
    const {
      client
    } = this.options;
    const {
      endpoints
    } = await client.inference.get({
      inference_id: '_all',
      task_type: taskType
    });
    return {
      inferenceEndpoints: endpoints.map(endpoint => ({
        inference_id: endpoint.inference_id,
        task_type: endpoint.task_type
      }))
    };
  }
}
exports.EsqlService = EsqlService;