"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormatter = exports.getAvailableFormatter = exports.generateFormatters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const generateFormatters = (visData, formatFactory) => visData.columns.reduce((newFormatters, column) => {
  var _column$meta;
  return {
    ...newFormatters,
    [column.id]: column !== null && column !== void 0 && (_column$meta = column.meta) !== null && _column$meta !== void 0 && _column$meta.params ? formatFactory(column.meta.params) : undefined
  };
}, {});
exports.generateFormatters = generateFormatters;
const getAvailableFormatter = (column, formatters, defaultFormatFactory) => {
  var _column$meta2;
  if (column !== null && column !== void 0 && (_column$meta2 = column.meta) !== null && _column$meta2 !== void 0 && _column$meta2.params) {
    const formatter = column !== null && column !== void 0 && column.id ? formatters[column === null || column === void 0 ? void 0 : column.id] : undefined;
    if (formatter) {
      return formatter;
    }
  }
  if (column !== null && column !== void 0 && column.format) {
    return defaultFormatFactory(column.format);
  }
};
exports.getAvailableFormatter = getAvailableFormatter;
const getFormatter = (column, formatters, defaultFormatFactory) => {
  var _getAvailableFormatte;
  return (_getAvailableFormatte = getAvailableFormatter(column, formatters, defaultFormatFactory)) !== null && _getAvailableFormatte !== void 0 ? _getAvailableFormatte : defaultFormatFactory();
};
exports.getFormatter = getFormatter;