"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBox = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/components/package_list_grid/search_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchBox = ({
  searchTerm,
  setSearchTerm,
  selectedCategory,
  setCategory,
  categories,
  availableSubCategories,
  setSelectedSubCategory,
  selectedSubCategory,
  setUrlandReplaceHistory,
  onlyAgentlessFilter = false
}) => {
  var _categories$find;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onQueryChange = e => {
    const queryText = e.target.value;
    setSearchTerm(queryText);
    setUrlandReplaceHistory({
      searchString: queryText,
      categoryId: selectedCategory,
      subCategoryId: selectedSubCategory,
      onlyAgentless: onlyAgentlessFilter
    });
  };
  const onCategoryButtonClick = () => {
    if (selectedSubCategory) {
      if (setSelectedSubCategory) setSelectedSubCategory(undefined);
      setUrlandReplaceHistory({
        categoryId: selectedCategory,
        subCategoryId: '',
        onlyAgentless: onlyAgentlessFilter
      });
    } else {
      setCategory('');
      if (setSelectedSubCategory) setSelectedSubCategory(undefined);
      setUrlandReplaceHistory({
        searchString: '',
        categoryId: '',
        subCategoryId: '',
        onlyAgentless: onlyAgentlessFilter
      });
    }
  };
  const selectedCategoryTitle = selectedCategory ? (_categories$find = categories.find(category => category.id === selectedCategory)) === null || _categories$find === void 0 ? void 0 : _categories$find.title : undefined;
  const getCategoriesLabel = (0, _react.useMemo)(() => {
    var _availableSubCategori;
    const selectedSubCategoryTitle = selectedSubCategory && availableSubCategories ? (_availableSubCategori = availableSubCategories.find(subCat => subCat.id === selectedSubCategory)) === null || _availableSubCategori === void 0 ? void 0 : _availableSubCategori.title : undefined;
    if (selectedCategoryTitle && selectedSubCategoryTitle) {
      return `${selectedCategoryTitle}, ${selectedSubCategoryTitle}`;
    } else if (selectedCategoryTitle) {
      return `${selectedCategoryTitle}`;
    } else return '';
  }, [availableSubCategories, selectedCategoryTitle, selectedSubCategory]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "epmList.searchBar",
    placeholder: _i18n.i18n.translate('xpack.fleet.epmList.searchPackagesPlaceholder', {
      defaultMessage: 'Search for integrations'
    }),
    value: searchTerm,
    onChange: e => onQueryChange(e),
    isClearable: true,
    incremental: true,
    fullWidth: true,
    prepend: selectedCategoryTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "epmList.categoryBadge",
      size: "xs",
      style: {
        display: 'flex',
        alignItems: 'center',
        fontWeight: euiTheme.font.weight.bold,
        backgroundColor: euiTheme.colors.lightestShade
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }, "Searching category: ")), getCategoriesLabel, /*#__PURE__*/_react.default.createElement("button", {
      "data-test-subj": "epmList.categoryBadge.closeBtn",
      onClick: onCategoryButtonClick,
      "aria-label": "Remove filter",
      style: {
        padding: euiTheme.size.xs,
        paddingTop: '2px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      color: "text",
      size: "s",
      style: {
        width: 'auto',
        padding: 0,
        backgroundColor: euiTheme.colors.lightestShade
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 15
      }
    }))) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
};
exports.SearchBox = SearchBox;