"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetPipeline = exports.useGetComponentTemplateQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetPipeline = pipelineId => {
  return (0, _use_request.useRequest)({
    path: `/api/ingest_pipelines/${pipelineId}`,
    method: 'get'
  });
};
exports.useGetPipeline = useGetPipeline;
const useGetComponentTemplateQuery = componentTemplateName => {
  return (0, _reactQuery.useQuery)({
    queryKey: ['component_templates', componentTemplateName],
    queryFn: async () => {
      const {
        data,
        error
      } = await (0, _use_request.sendRequest)({
        path: `/api/index_management/component_templates/${componentTemplateName}`,
        method: 'get'
      });
      if (error) {
        throw error;
      }
      return data;
    },
    retry: (failureCount, error) => {
      if (failureCount > 3 || error && error.statusCode === 404) {
        return false;
      }
      return true;
    }
  });
};
exports.useGetComponentTemplateQuery = useGetComponentTemplateQuery;