"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkRequestDiagnostics = bulkRequestDiagnostics;
exports.requestDiagnostics = requestDiagnostics;
var _constants = require("../../constants");
var _get_current_namespace = require("../spaces/get_current_namespace");
var _crud = require("./crud");
var _actions = require("./actions");
var _request_diagnostics_action_runner = require("./request_diagnostics_action_runner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function requestDiagnostics(esClient, soClient, agentId, additionalMetrics) {
  const currentSpaceId = (0, _get_current_namespace.getCurrentNamespace)(soClient);
  const response = await (0, _actions.createAgentAction)(esClient, soClient, {
    agents: [agentId],
    created_at: new Date().toISOString(),
    type: 'REQUEST_DIAGNOSTICS',
    expiration: new Date(Date.now() + _constants.REQUEST_DIAGNOSTICS_TIMEOUT_MS).toISOString(),
    data: {
      additional_metrics: additionalMetrics
    },
    namespaces: [currentSpaceId]
  });
  return {
    actionId: response.id
  };
}
async function bulkRequestDiagnostics(esClient, soClient, options) {
  var _options$batchSize;
  const currentSpaceId = (0, _get_current_namespace.getCurrentNamespace)(soClient);
  if ('agentIds' in options) {
    const givenAgents = await (0, _crud.getAgents)(esClient, soClient, options);
    return await (0, _request_diagnostics_action_runner.requestDiagnosticsBatch)(esClient, givenAgents, {
      additionalMetrics: options.additionalMetrics,
      spaceId: currentSpaceId
    });
  }
  const batchSize = (_options$batchSize = options.batchSize) !== null && _options$batchSize !== void 0 ? _options$batchSize : _constants.SO_SEARCH_LIMIT;
  const res = await (0, _crud.getAgentsByKuery)(esClient, soClient, {
    kuery: options.kuery,
    spaceId: currentSpaceId,
    showInactive: false,
    page: 1,
    perPage: batchSize
  });
  if (res.total <= batchSize) {
    return await (0, _request_diagnostics_action_runner.requestDiagnosticsBatch)(esClient, res.agents, {
      additionalMetrics: options.additionalMetrics,
      spaceId: currentSpaceId
    });
  } else {
    return await new _request_diagnostics_action_runner.RequestDiagnosticsActionRunner(esClient, soClient, {
      ...options,
      batchSize,
      total: res.total,
      spaceId: currentSpaceId
    }, {
      pitId: await (0, _crud.openPointInTime)(esClient)
    }).runActionAsyncTask();
  }
}